﻿using System;
using System.Threading;
using System.Threading.Tasks;
using gov.va.med.VBECS.Communication.Common;

namespace gov.va.med.VBECS.Communication.Channels
{
    internal class EchoChannel : BaseChannel
    {
        private readonly int[] _delays = {10, 33, 990, 500, 200, 3, 150, 250, 750, 44, 69};
        private int _delayCounter;

        protected override void SendImpl(IMessage aMessage)
        {
            Task.Run(() => do_send(aMessage));
        }

        private void do_send(IMessage aMessage)
        {
            if (_delayCounter >= _delays.Length)
                _delayCounter = 0;
            var delay = _delays[_delayCounter++];
            //Emulate work
            Console.WriteLine("Delay [{0}]", delay);
            Thread.Sleep(delay);
            FireMessageReceivedEvent(new RawDataMessage(aMessage.Id, aMessage.GetBytes()));
        }

        protected override void StartImpl()
        {
        }

        protected override void DisconnectImpl()
        {
        }
    }
}